// This file has been prepared for Doxygen automatic documentation generation.
/** \file ********************************************************************
*
* 
*
* - File              : uart1.c
* - Compiler          : WinAVR 20100110
* - Supported devices : ATMXmega128A1
* - Author			  : Dominic Rathje (dominic.rathje@uni-ulm.de)
*
* - Description       : Implementation of USART Stack
*
* $Revision: 1.0 $
*****************************************************************************/

#define _UART1_C_ 1

#include <avr/io.h>
#include <stdio.h>
#include <avr/interrupt.h>
#include "uart1.h"
#include "../pmc.h"

uint8_t uart1_rx_buffer[UART1_RX_BUFFER_SIZE];
uint8_t uart1_tx_buffer[UART1_TX_BUFFER_SIZE];

volatile uint8_t uart1_rx_head=0, uart1_rx_tail=0;
volatile uint8_t uart1_tx_head=0, uart1_tx_tail=0;

void uart1_init(void) {


	UART1.CTRLB = USART_RXEN_bm | USART_TXEN_bm;
	UART1_PORT.DIRSET = UART1_TXPIN_bm;
	UART1_PORT.DIRCLR = UART1_RXPIN_bm;
	
	UART1.CTRLC = UART1_CHSIZE_gc;
	UART1.BAUDCTRLA = (uint8_t)UART1_BSEL;
	UART1.BAUDCTRLB = (((uint8_t)(UART1_BSEL>>8))<<USART_BSEL_gp) | ( ((UART1_BSCALE) & 0x0f) << USART_BSCALE_gp );
	
	uart1_rxc_int_en();
	
}

void uart1_sendbyte(uint8_t data) {
	while(uart1_tx_head == ((uart1_tx_tail-1)&(UART1_TX_BUFFER_SIZE-1)) ) {}
	uart1_tx_buffer[uart1_tx_head++] = data;
	uart1_tx_head &= (UART1_TX_BUFFER_SIZE-1);
	uart1_udre_int_en();
}

uint8_t uart1_getbyte(uint8_t *data) {
	if(uart1_rx_tail==uart1_rx_head) {
		return 0;
	} else {
		*data=uart1_rx_buffer[uart1_rx_tail++];
		uart1_rx_tail &= (UART1_RX_BUFFER_SIZE-1);
		return 1;
	}
}

int uart1_putchar(char c, FILE *sream) {
	while(uart1_tx_head == ((uart1_tx_tail-1)&(UART1_TX_BUFFER_SIZE-1)) ) {}
	uart1_tx_buffer[uart1_tx_head++] = c;
	uart1_tx_head &= (UART1_TX_BUFFER_SIZE-1);
	uart1_udre_int_en();
	return 0;
}

int uart1_getchar(FILE *stream) {
	int data;
	if(uart1_rx_tail==uart1_rx_head) {
		return _FDEV_EOF;
	} else {
		data= (int)uart1_rx_buffer[uart1_rx_tail++];
		uart1_rx_tail &= (UART1_RX_BUFFER_SIZE-1);
		return data;
	}

}

uint8_t uart1_senddata(uint8_t data){
	if(!(UART1.STATUS & USART_DREIF_bm)) { return 0; }
	UART1.CTRLB &= ~USART_TXB8_bm;
	UART1.DATA = data;
	return 1;
}


uint8_t uart1_sendid(uint8_t data){
	if(!(UART1.STATUS & USART_DREIF_bm) ) { return 0; }
	UART1.CTRLB |= USART_TXB8_bm;
	UART1.DATA = data;
	return 1;
}

ISR(UART1_RXC_vect) {
	pmc_rx_int( (UART1.STATUS & 0x01), UART1.DATA);
	
	//if(uart1_rx_head != uart1_rx_tail-1) {
		//uart1_rx_buffer[uart1_rx_head++] = UART1.DATA;
		//uart1_rx_head &= (UART1_RX_BUFFER_SIZE-1);
	//}
}

ISR(UART1_DRE_vect) {
	if(uart1_tx_tail==uart1_tx_head) {
		uart1_udre_int_dis();
	} else {
		UART1.DATA = uart1_tx_buffer[uart1_tx_tail++];
		uart1_tx_tail &= (UART1_TX_BUFFER_SIZE-1);
	}
}
