/** \file ******************************************************************
* \brief Button Interface
* 
* \author Dominic Rathje (dominic.rathje@uni-ulm.de)
* \version 1.0
* \note
* - Compiler          : WinAVR 20100110
* - Supported devices : ATMega8
*
*****************************************************************************/


#ifndef _BUTTON_H_
#define _BUTTON_H_ 1


/** \brief Initialise the Button Interface
 *
 * Configures the Port Registers. Call this function at the beginning of your main function.
 */
void button_init(void);


/** \brief Button Process
 *
 * Reads the Ports and sends the according character to the Host on any pinchange
 * Call this function regularly in main loop.
 */
void button_process(void);

#endif //_BUTTON_H_
