/** \file ******************************************************************
* \brief Buzzer driver
* 
* \author Dominic Rathje (dominic.rathje@uni-ulm.de)
* \version 1.0
* \note
* - Compiler          : WinAVR 20100110
* - Supported devices : ATMega8
*
*****************************************************************************/

#define _BUZZER_C_ 1

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

#include "buzzer.h"

uint16_t buzzer_time=0;


void buzzer_init(void) {
	
	ICR1 = BUZZER_FREQ;
	OCR1A = BUZZER_FREQ/2;
	OCR1B = BUZZER_FREQ/2;
	TCCR1A = (1<<WGM11);
	TCCR1B = (1<<CS10) | (1<<WGM13) | (1<<WGM12);
	
	TIMSK |= (1<<TOIE1);
	
	DDRB |= (1<<PB1) | (1<<PB2);
	
}

void buzzer_start(uint16_t time) {
	
	TCCR1A = (1<<COM1A1) | (1<<COM1B1) | (1<<COM1B0) | (1<<WGM11);
	buzzer_time=time;
	
}


void buzzer_stop(void) {
	
	TCCR1A = (1<<WGM11);
	
}

ISR(TIMER1_OVF_vect) {
	if(buzzer_time) {
		
		if(buzzer_time==1) {
			buzzer_stop();
		}
		buzzer_time--;
		
	}
}
