/** \file ******************************************************************
* \brief Buzzer driver
* 
* \author Dominic Rathje (dominic.rathje@uni-ulm.de)
* \version 1.0
* \note
* - Compiler          : WinAVR 20100110
* - Supported devices : ATMega8
*
*****************************************************************************/


#ifndef _BUZZER_H_
#define _BUZZER_H_ 1

#define BUZZER_FREQ 1843 ///< TOP value for counter register to generate a 4000Hz sound.


/** \brief Initialise the Buzzer driver
 *
 * Configures the Port Registers and Timer. Call this function at the beginning of your main function.
 */
void buzzer_init(void);

/** \brief start making noise
 *
 * call this function to start the buzzer. the sund will be disabled after time ticks. one tick equals 0.25ms
 * 
 * \param time duration of the beep
 */
void buzzer_start(uint16_t time);

/** \brief stop making noise
 *
 * this function disables the buzzer. for those who want to do the timing be themselves
 */
void buzzer_stop(void);


#endif // _BUZZER_H_
